//
//  Chap1.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/03/30.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap1_h
#define Chap1_h
/*---------------------------------------*/
/*［１］基本関数                            */
/*---------------------------------------*/
//正弦積分
double Si(double x){/*正弦積分．二宮市三のNUMPAC関数を移植*/
    double AX, T, v, AMP, PHS;
    double Big = 3.53e+15;
    double HP = 1.57079632679489661923e+00;
    double A0 = 9.99999999999999999171e-01;
    double A1 = -5.55555555555555219562e-02;
    double A2 = 1.66666666666644244698e-03;
    double A3 = -2.83446712012379202114e-05;
    double A4 = 3.06192435080324810185e-07;
    double A5 = -2.27746386204507202727e-09;
    double A6 = 1.23528824195541075837e-11;
    double A7 = -5.09244381760795653840e-14;
    double A8 = 1.57767289707190675574e-16;
    double B0 = 1.84865252799946825634e+00;
    double B1 = 4.70400026866224502929e-02;
    double B2 = -1.72838749881177971183e-01;
    double B3 = 3.05686106369342127007e-02;
    double B4 = 6.10774312688322617524e-03;
    double B5 = -1.23673147809638105195e-03;
    double B6 = -1.14793337838135733178e-04;
    double B7 = 2.34647625764878103010e-05;
    double B8 = 1.34057266548074469662e-06;
    double B9 = -2.67576877633572996062e-07;
    double B10 = -1.06653342306219184552e-08;
    double B11 = 2.05320535055357656248e-09;
    double B12 = 6.14718656171870448022e-11;
    double B13 = -1.11853848291960533470e-11;
    double B14 = -2.64538000599048683188e-13;
    double C0 = 1.54993124494467413739e+00;
    double C1 = -1.91784854932627693224e-01;
    double C2 = 4.75447040395853819276e-02;
    double C3 = 2.56248486168265403962e-02;
    double C4 = -6.20757883805058838231e-03;
    double C5 = -6.04994510350165064987e-04;
    double C6 = 1.79627469907123647126e-04;
    double C7 = 7.25927002467713636303e-06;
    double C8 = -2.67742673765837827091e-06;
    double C9 = -5.25206665342284508878e-08;
    double C10 = 2.50876422688827589905e-08;
    double C11 = 2.43217726795721753928e-10;
    double C12 = -1.63010065780236322978e-10;
    double C13 = -6.97813097498053251253e-13;
    double C14 = 7.69197633526927481572e-13;
    double D0 = 1.45459661424809359056e+00;
    double D1 = 9.38552283883984008627e-02;
    double D2 = 4.71462161396361628639e-02;
    double D3 = -2.01326538875540474713e-02;
    double D4 = -2.33044335932930554655e-03;
    double D5 = 1.04846328714359582460e-03;
    double D6 = 2.47667226292501843206e-05;
    double D7 = -2.16547289602533792410e-05;
    double D8 = 3.57021871482639877799e-08;
    double D9 = 2.54106046409090349451e-07;
    double D10 = -2.99147461183675064282e-09;
    double D11 = -1.96251690386871481031e-09;
    double D12 = 3.21793277727385577662e-11;
    double D13 = 1.06605598061812293582e-11;
    double D14 = -1.97268337707755991628e-13;
    double E0 = 1.23125385281514935557e+01;
    double E1 = 9.05447691025208141309e+01;
    double E2 = 2.95474567596582779016e+02;
    double E3 = 5.83131198196978351155e+02;
    double E4 = 7.16935769366137725046e+02;
    double E5 = 5.58622350386385382542e+02;
    double E6 = 2.54681589685065285568e+02;
    double E7 = 5.77936703024364931892e+01;
    double E8 = 2.90244943012039502024e+00;
    double F0 = 9.85003082252119486953e+01;
    double F1 = 7.24358152820166225359e+02;
    double F2 = 2.36610514174674441158e+03;
    double F3 = 4.68202672977863201440e+03;
    double F4 = 5.79048783971905802014e+03;
    double F5 = 4.57537584701306123041e+03;
    double F6 = 2.16249003412140601656e+03;
    double F7 = 5.49671263303621463619e+02;
    double F8 = 5.24479381649037257581e+01;
    double G0 = 1.28361962503868125219e-01;
    double G1 = 5.60500450182444141623e+00;
    double G2 = 2.49956335491706776219e+01;
    double G3 = 6.46771120580147976191e+01;
    double G4 = 9.87142892554887308460e+01;
    double G5 = 9.61475187987074343351e+01;
    double G6 = 5.50869704124655348746e+01;
    double G7 = 1.62263871683213855949e+01;
    double G8 = 1.04533228046412399614e+00;
    double H0 = 1.02689570003095654107e+00;
    double H1 = 4.48400360145918561962e+01;
    double H2 = 2.00034597790108682751e+02;
    double H3 = 5.20452940549418121168e+02;
    double H4 = 8.03235208680012985532e+02;
    double H5 = 8.03409801489373314695e+02;
    double H6 = 4.90595180073060710901e+02;
    double H7 = 1.73202840882625291402e+02;
    double H8 = 2.66617300458030209829e+01;
    AX = fabs(x);
    if(AX <= 2){
        T = x*x;
        return ((((((((A8*T + A7)*T + A6)*T + A5)*T + A4)*T + A3)*T +
                  A2)*T +A1)*T + A0)*x;
    }
    if(AX <= 4){
        T = AX - 3;
        v = (((((((((((((B14*T + B13)*T + B12)*T + B11)*T + B10)*T + B9)*T +
                    B8)*T + B7)*T + B6)*T + B5)*T + B4)*T + B3)*T +
              B2)*T + B1)*T + B0;
        if(x<0){v=-v;}
        return v;
    }
    if(AX <= 6){
        T = AX - 5;
        v = (((((((((((((C14*T + C13)*T + C12)*T + C11)*T + C10)*T + C9)*T +
                    C8)*T + C7)*T + C6)*T + C5)*T + C4)*T + C3)*T +
              C2)*T + C1)*T + C0;
        if(x<0){v=-v;}
        return v;
    }
    if(AX <= 8){
        T = AX - 7;
        v = (((((((((((((D14*T + D13)*T + D12)*T + D11)*T + D10)*T + D9)*T +
                    D8)*T + D7)*T + D6)*T + D5)*T + D4)*T + D3)*T +
              D2)*T + D1)*T + D0;
        if(x<0){v=-v;}
        return v;
    }
    if(AX <= Big){
        T = 8/AX;
        AMP = ((((((((E8*T + E7)*T + E6)*T + E5)*T + E4)*T + E3)*T + E2)*T +
                E1)*T + E0)/(((((((((T + F8)*T + F7)*T + F6)*T + F5)*T + F4)*
                                T + F3)*T + F2)*T + F1)*T + F0);
        PHS = ((((((((G8*T + G7)*T + G6)*T + G5)*T + G4)*T + G3)*T + G2)*T +
                G1)*T + G0)/(((((((((T + H8)*T + H7)*T + H6)*T + H5)*T + H4)*
                                T + H3)*T + H2)*T + H1)*T + H0)*T;
        v = HP - cos(AX - PHS)*AMP*T;
        if(x<0){v=-v;}
        return v;
    }
    return HP;
};

//正規分布
double phiPDF(double sg,double x){/* =ϕ(σ,x):正規分布密度関数：平均０，標準偏差sg*/
    return exp(-x*x/(2*sg*sg))/(sqrt(2*M_PI)*sg);
};
double PhiCDF(double sg,double x){/* =Φ(σ,x):正規分布分布関数：平均０，標準偏差sg*/
    return erfc(-x/(sqrt(2)*sg))/2;
};
double PhiSvF(double sg,double x){/*正規分布生存関数：平均０，標準偏差sg*/
    return erfc(x/(sqrt(2)*sg))/2;
};

//正規化χ分布：自由度m
double gPDF(double x,int m){//=g(x|m) ：密度関数
    double m1,mh;
    m1=m;
    mh=m1/2;
    return 2*pow(mh,mh)/tgamma(mh)*pow(x,m1-1)*exp(-m1*x*x/2);
};
double g1PDF(double x,int m){//=g(1+x,m)：密度関数の原点を1にシフト
    long double pil=3.14159265358979323846L;//拡張倍精度pi
    long double mH,xH,Y,Z,mh,mr,ms,S;
    long double B[5]={
        0.0833333333333333333333L,-0.00277777777777777777778L,
        0.000793650793650793650794L,-0.000595238095238095238095L,
        0.000841750841750841750842L};
    long double c[8]={
        0.333333333333333333333L,-0.250000000000000000000L,
        0.200000000000000000000L,-0.166666666666666666667L,
        0.142857142857142857143L,-0.125000000000000000000L,
        0.111111111111111111111L,-0.100000000000000000000L};
    if(x<-1) return 0;
    xH=x;mH=m;//拡張倍精度計算
    mh=0.5*mH;
    mr=2/mH;
    ms=mr*mr;
    //Yの計算
    if(m<=42){
        Y=-0.5*(2*lgammal(mh) - mH*logl(mh) + mH + logl(mH/(4*pil)));
    }else{
        Y=-((((B[4]*ms+B[3])*ms+B[2])*ms+B[1])*ms+B[0])*mr;
    };
    //Zの計算
    if(m<=22000||fabs(x)>8.6/sqrt(2*mH)){
        Z=-mH/2*xH*(2 + xH) + (mH - 1)*logl(1 + xH);
    }else{
        S=(((((((c[7]*xH+c[6])*xH+c[5])*xH+c[4])*xH+c[3])*xH+c[2])*xH+c[1])*xH+c[0])*xH*xH*xH;
        Z=-(2*mH-1)/2*xH*xH - xH + (mH-1)*S;
    };
    return (double)sqrtl(mH/pil)*expl(Y+Z);
};

//F分布：自由度(l,m)
double FSvF(double x,int l,int m){/*生存関数*/
    double B,y,pr,dnA,dnB,nmB;
    int l0,l1,m0,m1,i;
    if(x<0) return 0;
    y=m/(m+l*x);
    l0 = 2 - l%2;
    l1 = (l - l0)/2;
    m0 = 2 - m%2;
    m1 = (m - m0)/2;
    if(l0 == 1){
        if(m0 ==1){
            pr = 1 - atan(sqrt(l*x/m))*2/M_PI;
        }else{
            pr = y/(1 + sqrt(l*x/(m + l*x)));
        };
    }else{
        if(m0==1){
            pr=sqrt(y);
        }else{
            pr=y;
        };
    };
    if(l0 == 1){
        if(m0 == 1){
            B=sqrt(y*l*x/(m + l*x))/M_PI;
        }else{
            B=y*sqrt(l*x/(m + l*x))/2;
        };
    }else{
        if(m0 == 1){
            B=sqrt(y)* l*x/(m + l*x)/2;
        }else{
            B=y*l*x/(m + l*x);
        };
    };
    if(l1 >= 1){
        nmB = l0 + m0;
        dnB = l0;
        dnA = l0;
        if(l1 >= 1){
            for(i = 1;i <= l1;i++){
                pr += 2/dnA*B;
                B *= nmB/dnB*(1 - y);
                dnA += 2; dnB += 2; nmB += 2;
            };
        };
    };
    if(m1 >= 1){
        nmB = l + m0;
        dnB = m0;
        dnA = m0;
        for(i = 1;i <= m1;i++){
            pr -= 2/dnA*B;
            B *= nmB/dnB*y;
            dnA += 2; dnB += 2; nmB += 2;
        };
    };
    return pr;
};
double FCDF(double x,int l,int m){/*分布関数*/
    return 1-FSvF(x,l,m);
};
    
//χ自乗分布：自由度m
double chi2SvF(double x,int m){/*生存関数*/
    double a,c,s,pr;
    int n,i;
    if(x < 0) return 0;
    if(m%2==1){
        n = (m+1)/2;
        a = 2*(1 - PhiCDF(1, sqrt(x)));
        if(n == 1){
            pr = a;
        }else{
            c = exp(-x/2)*sqrt(2*x/M_PI);
            s = c;
            for(i = 2;i <= n - 1;i++){
                c *= x/(2*i - 1);
                s += c;
            };
            pr = a + s;
        };
    }else{
        n = m/2;
        a = exp(-x/2);
        //b = a/2;
        if(n == 1){
            pr = a;
        }else{
            c = a*x/2;
            s = c;
            for(i = 2;i <= n - 1;i++){
                c *= x/(2*i);
                s += c;
            };
            pr = a + s;
        };
    };
    return pr;
};
double chi2CDF(double x,int m){/*分布関数*/
    return 1-chi2SvF(x,m);
};
    
//t分布：母数m　m → ∞ の漸近分布は標準正規分布
double tSvF(double x,int m){/*生存関数：m = -1はm=∞ を意味する*/
    double y,a,b,c,s,pr,xx;
    int n,i2;
    if(m==-1) return PhiSvF(1,x);/*漸近分布関数=標準正規分布関数*/
    xx = x*x;
    y = m/(m + xx);
    if(m%2 == 1){
        n = (m + 1)/2;
        a = 0.5 - atan(fabs(x)/(sqrt((double)m))*M_PI);
        b = sqrt(y*xx/(m + xx))/M_PI;
        if(n == 1){
            pr = a;
        }else{
            c = 1; s = c;
            for(i2 = 4;i2 <= 2*(n - 1);i2+=2 ){
                c *= y*(i2 - 2)/(i2 - 3);
                s += c/(i2 - 1);
            };
            pr = a - b*s;
        };
    }else{
        n = m/2;
        a = (1 - sqrt(xx/(m + xx)))/2;
        b = y*sqrt(xx/(m + xx))/2;
        if(n == 1){
            pr = a;
        }else{
            c = 1; s = c/2;
            for(i2 = 4;i2 <= 2*(n - 1);i2+=2){
                c *= y*(i2 - 1)/(i2 - 2);
                s += c/i2;
            };
            pr = a - b*s;
        };
    };
    if(x < 0) pr = 1 - pr;
    return pr;
};
double tCDF(double x,int m){/*分布関数*/
    return 1-tSvF(x,m);
};

//変形検定水準
double alMl(double al,int M,int l) {return 1-pow(1-al,(double)l/M);};

// sinc近似
double sinc(double x){/*sinc(x)：sinc関数*/
    if(x==0) return 1; else return sin(x)/x;
};
double snc(double h,double a,double x){/*中心a,標本点間隔hのsinc基底*/
    return sinc(M_PI*(x-a)/h);
};
double Snc(double h,double a,double x){/*中心a,標本点間隔hのsinc基底の不定積分*/
    return h*(Si(M_PI*(x-a)/h)/M_PI+0.5);
};

#endif /* Chap1_h */


